/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-08-06 16:08:24
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 16:40:38
 * @FilePath: /review-front/src/utils/filter.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
export const filters = {
  /**
   * @description: 本地字典过滤器
   * @param {*} dictKey 字典名称
   * @param {*} code  code
   * @return {*}
   * @author: Lqi
   */
  localDictFilter(dictKey, code, initVal = false) {
    let _t = initVal ? '无' : ''
    const _localDict = JSON.parse(localStorage.getItem(dictKey))
    if (_localDict) {
      _localDict.filter((v) => {
        if (v.code === code) {
          _t = v.name
        }
      })
    }
    return _t
  },
  /**
   * @description: 性别
   * @param {*} sex
   * @return {*}
   * @author: Lqi
   */
  sexFilter(sex) {
    return sex === 1 ? '男' : '女'
  },
  /**
   * @description: 评审类型
   * @param {*} type
   * @return {*}
   * @author: Lqi
   */
  reviewTypeFilter(type) {
    return { HO: '卫生评审', COMMON: '公告评审', EDU: '教育评审' }[type]
  },
  /**
   * @description: 文件大小
   * @param {*} bytes
   * @return {*}
   * @author: Lqi
   */
  formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes'
    const k = 1024
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB']
    const i = Math.floor(Math.log(bytes) / Math.log(k))
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i]
  }
}
