/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:20:32
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 09:29:35
 * @FilePath: /review-front/src/stores/modules/user.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ref } from 'vue'
import store from '@/stores'
import { defineStore } from 'pinia'
import {
  loginByUsername,
  logout,
  adminLogin as adminLoginByUsername,
  adminLogout
} from '@/api/login'
import { useRouter } from 'vue-router'
import { message } from 'ant-design-vue'
import Cookies from 'js-cookie'

export const useUserStore = defineStore(
  'user',
  () => {
    let token = ref('')
    let userName = ref('')
    let expertUser = ref({})
    let userInfo = ref({})
    let loginType = ref('expertUser')
    let isAdmin = ref(false)
    const router = useRouter()

    /**
     * @description: 用户登录
     * @param {*} username
     * @param {*} password
     * @param {*} type
     * @return {*}
     * @author: Lqi
     */
    const login = async ({ username, password, type }) => {
      try {
        const res = await loginByUsername({ username, password }, type)
        token.value = res.data.access_token
        expertUser.value = res.data.expertUser
        Cookies.set('Access-Token', res.data.access_token)
        userInfo.value = res.data.info
        loginType.value = type
        console.log(type)
        console.log(token.value)
        userName.value = res.data.expertUser.userName
      } catch (error) {
        throw new Error(error)
      }
    }

    /**
     * @description: 管理员登录
     * @param {*} username
     * @param {*} password
     * @param {*} type
     * @return {*}
     * @author: Lqi
     */
    const adminLogin = async (data, type) => {
      try {
        const res = await adminLoginByUsername(data)
        isAdmin.value = type === 'admin'
        token.value = res.data.access_token
        userName.value = '超级管理员'
        console.log(res.data)
      } catch (error) {
        throw new Error(error)
      }
    }

    const setUserName = (name) => {
      userName.value = name
      expertUser.value.userName = name
    }

    const setUserInfo = (info) => {
      userInfo.value = Object.assign({}, userInfo.value, info)
    }
    const loginOut = async () => {
      const res = await logout(loginType.value)

      if (res.code === 200) {
        FedLogOut()
        message.success(res.message)
        console.log(res.message)
      }
    }

    const logoutByAdmin = async () => {
      const res = await adminLogout()

      if (res.code === 200) {
        FedLogOut()
        message.success(res.message)
        console.log(res.message)
      }
    }

    const FedLogOut = () => {
      localStorage.removeItem('app')
      localStorage.removeItem('plan')
      localStorage.removeItem('user')
      console.log(router)
      // router.push({ path: '/' })
    }

    return {
      userName,
      token,
      expertUser,
      userInfo,
      login,
      loginOut,
      FedLogOut,
      loginType,
      setUserInfo,
      setUserName,
      adminLogin,
      logoutByAdmin
    }
  },
  {
    persist: true
  }
)

export function useUserStoreHook() {
  return useUserStore(store)
}
