/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:21:06
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-11-21 18:12:54
 * @FilePath: /review-front/src/stores/modules/data.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ref, reactive } from 'vue'
import store from '@/stores'
import { defineStore } from 'pinia'
import { fetchReviewList, getReviewAllIds } from '@/api/user/reviewList'
import { getScoreInfo, getMainScoreInfo, getReviewDetail } from '@/api/user/details'
import {
  getScoreExtendByReportId,
  getExamScoreByUserId,
  getRankSituationByUserId,
  getWorkloadByUserId,
  getDRGInfo
} from '@/api/user/ho'
import { enclosure } from '@/api/user/details'
import { usePlanStore } from './plan'
import { useAppStore } from './app'
import { incognito } from '@/utils'
import { cloneDeep } from 'lodash-es'
export const useDataStore = defineStore('data', () => {
  const searchBar = reactive({
    searchTypeOptions: [
      { label: '全部', value: 0 },
      { label: '主审', value: 1 },
      { label: '辅审', value: 4 },
      { label: '待审核', value: 2 },
      { label: '已审核', value: 3 },
      { label: '通过', value: 5 },
      { label: '不通过', value: 6 }
    ]
  })

  const usePlan = usePlanStore()
  const useApp = useAppStore()

  // const planInfo = ref({})
  // const groupInfo = ref({})

  // page
  const reviewPage = reactive({
    total: 0
  })

  const listQuery = reactive({
    current: 1,
    size: 10,
    params: {
      eq: {
        p: {
          reportSpecialtyFirstCode: '',
          reportSpecialtySecondCode: '',
          reportSpecialtyThirdCode: ''
        },
        o: {
          isQualified: '',
          isAgreen: ''
        }
      }
    },
    values: {
      type: 0,
      searchKey: '',
      groupId: 0,
      planId: 0,
      reportSpecialtyFirstCode: '',
      reportSpecialtySecondCode: '',
      reportSpecialtyThirdCode: ''
    }
  })

  // loading
  const fetchLoading = ref(false)
  // 搜索类型
  const searchType = ref(0)
  // 检索关键字
  const searchKey = ref('')
  // 审核列表数据缓存
  const reviewListData = ref([])
  // 申报ID
  const reportId = ref(0)
  // personnelId
  const personnelId = ref(0)
  //上一次获取的申报ID
  const preReportId = ref(0)
  // 申报年份
  const year = ref('')
  // 申报表缓存数据
  const reportForm = reactive({
    id: { data: 0, error: false },
    // 个人基本信息
    userInfo: { data: null, error: false },
    // 申报信息
    report: { data: null, error: false },
    // 学历信息
    edu: { data: null, error: false },
    // 职称情况
    rank: { data: null, error: false },
    // 学习经历
    study: { data: null, error: false },
    // 工作情况
    work: { data: null, error: false },
    // 专业技术工作总结
    summary: { data: null, error: false },
    // 完成主要专业技术工作情况
    finished: { data: null, error: false },
    // 承担课题（项目）情况
    project: { data: null, error: false },
    // 专利情况
    patent: { data: null, error: false },
    // 表彰奖励
    reward: { data: null, error: false },
    // 论文著作情况
    thesis: { data: null, error: false },
    // 参加继续教育和学术活动
    learn: { data: null, error: false },
    // 年度考核
    appraise: { data: null, error: false }
  })

  const reviewType = ref('')

  const userId = ref(0)

  const currentUserInfo = ref({})

  // 附件数据
  const annex = reactive({
    id: 0,
    list: []
  })
  // 附件是否加载完成
  const isAnnexLoaded = ref(false)
  // 附件加载loading
  const annexLoading = ref(false)
  // 查询所有ids
  const allIds = reactive({
    ids: [],
    loading: false
  })

  const personalDetail = reactive({
    score: {},
    mainScore: {},
    detail: {}
  })

  const totalCache = reactive([])
  const initHoSpecial = () => ({
    userId: 0,
    loading: false,
    score: {
      data: {},
      loading: false
    },
    exams: {
      data: [],
      loading: false
    },
    histories: {
      data: [],
      loading: false
    },
    workload: {
      data: {},
      loading: false
    },
    drg: {
      data: {},
      loading: false
    }
  })
  const hoSpecial = reactive(initHoSpecial())
  const resDataStoreData = (fnList) => {
    for (let fn of fnList) {
      Object.assign(fn?.key, fn.data)
    }
  }

  const setReviewType = (val) => {
    reviewType.value = val
  }

  // 获取个人详情
  const getPersonalDetail = {
    /**
     * @description: 获取申报人详情
     * @return {*}
     * @author: Lqi
     */
    getUserDetailInfo: async () => {
      const res = await getReviewDetail(
        personnelId.value,
        usePlan.planInfo.id,
        usePlan.groupInfo.id
      )
      currentUserInfo.value = cloneDeep(res.data)

      // 匿名
      if (usePlan.groupInfo.isIncognito) {
        res.data.detail.userName = incognito()
      }

      setPersonalDetail('detail', res.data)
    },
    /**
     * @description: 获取打分信息
     * @return {*}
     * @author: Lqi
     */
    getUserScoreInfo: async () => {
      const res = await getScoreInfo({ personalId: personnelId.value })
      setPersonalDetail('score', res.data)
    },
    /**
     * @description: 获取主审打分信息
     * @return {*}
     * @author: Lqi
     */
    getUserMainScoreInfo: async () => {
      const res = await getMainScoreInfo({ personalId: personnelId.value })
      setPersonalDetail('mainScore', res.data)
    },
    getOpinion: async () => {}
  }

  /**
   * @description: 设置个人详情缓存
   * @param {*} key
   * @param {*} data
   * @return {*}
   * @author: Lqi
   */
  const setPersonalDetail = (key, data) => {
    personalDetail[key] = data
  }
  /**
   * @description: 数据加载loading
   * @param {*} loading
   * @return {*}
   * @author: Lqi
   */
  const setFetchLoading = (loading) => {
    fetchLoading.value = loading
  }

  // 打分模版数据

  const setReportId = (value) => {
    reportId.value = value
    // if (type === 'pre') {
    //   preReportId.value = value
    // } else {
    //   reportId.value = value
    // }
  }

  const setPersonnelId = (val) => {
    personnelId.value = val
  }

  /**
   * @description: 缓存列表数据
   * @return {*}
   * @author: Lqi
   */
  const setReviewList = (data) => {
    reviewListData.value = data
  }

  /**
   * @description: 缓存申报表信息
   * @param {*} key 表 key
   * @param {*} data 表数据
   * @param {*} error 请求是否存在错误，完善细节处理
   * @return {*}
   * @author: Lqi
   */
  const setReportForm = (key, data, reportId, error = false) => {
    try {
      let _data = { fullTime: [], executive: [] }
      if (key === 'edu') {
        data.forEach((i) => {
          if (i.eduTypeCode === '5001') {
            _data.fullTime.push(i)
          } else if (i.eduTypeCode === '5002') {
            _data.executive.push(i)
          }
        })
        reportForm[key].data = _data
        _setTotalCache({ data: _data, key }, reportId)
      } else {
        reportForm[key].data = data
        _setTotalCache({ data, key }, reportId)
      }
      reportForm[key].error = error
    } catch (error) {
      console.error([key], error)
    }
  }

  /**
   * @description: 更新列表数据
   * @param {*} data 当前操作数据
   * @param {*} isMultiple 是否是批量操作
   * @return {*}
   * @author: Lqi
   */
  const updateReviewList = (data) => {
    try {
      if (!data) return
      if (!Array.isArray(data)) {
        // data转换，适应批量操作逻辑
        data = [data]
      }
      data.forEach((item) => {
        const index = reviewListData.value.findIndex((r) => item.id === r.id)
        if (index !== -1) {
          // 先过滤空值
          const filteredObj = Object.keys(item).reduce((acc, key) => {
            // 只在值不为 null 或 undefined 时，才添加到中间对象中
            if (item[key] !== '') {
              acc[key] = item[key]
            }
            return acc
          }, {})
          reviewListData.value[index] = Object.assign({}, reviewListData.value[index], filteredObj)
        }
      })
    } catch (error) {
      console.warn(error)
    }
  }

  /**
   * @description: 设置搜索栏
   * @param {*} value
   * @return {*}
   * @author: Lqi
   */
  const setSearchBar = (value) => {
    searchBar.searchType = value
  }

  /**
   * @description: 设置搜索关键字
   * @param {*} value
   * @return {*}
   * @author: Lqi
   */
  const setSearchKey = (value) => {
    searchKey.value = value
  }

  const setSearchType = (value) => {
    searchType.value = value
  }
  /**
   * @description: 获取列表数据
   * @return {*}
   * @author: Lqi
   */
  const getData = async () => {
    try {
      setFetchLoading(true)
      if (usePlan.planInfo.id && usePlan.groupInfo.id) {
        listQuery.values.planId = usePlan.planInfo.id
        listQuery.values.groupId = usePlan.groupInfo.id
      }
      const res = await fetchReviewList(listQuery)

      if (usePlan.groupInfo.isIncognito) {
        for (let item of res.data.personnelList.records) {
          item.userName = incognito(item.userName)
        }
      }
      // if (
      //   res.data.personnelList?.records.length > 0 &&
      //   res.data.personnelList?.records[0]?.type !== usePlan.groupInfo.type
      // ) {
      //   console.log('不一致')
      //   router.push({ path: '/' })
      // }
      // console.log('getData', res)
      useApp.setVoteBtnText(parseInt(res.data.messageType))
      reviewPage.total = parseInt(res.data.personnelList.total)
      setReviewList(res.data.personnelList.records)
    } catch (error) {
      throw new Error(error)
    } finally {
      setFetchLoading(false)
    }
  }

  /**
   * @description: 获取所有ids
   * @param {*} second
   * @return {*}
   * @author: Lqi
   */
  const getAllIds = async () => {
    try {
      allIds.loading = true
      const res = await getReviewAllIds(listQuery)
      allIds.ids = res.data.personnelList
    } catch (error) {
      // throw new Error(error)
    } finally {
      allIds.loading = false
    }
  }

  /**
   * @description: 获取并缓存附件数据
   * @param {*} second
   * @return {*}
   * @author: Lqi
   */
  const getAnnex = async () => {
    try {
      // if (isAnnexLoaded.value) return
      annexLoading.value = true
      const res = await enclosure(userId.value, year.value)
      annex.id = userId.value

      if (JSON.parse(localStorage.getItem('plan')).groupInfo.isIncognito) {
        for (let list of res.data.attachmentList) {
          for (let file of list.fileImages) {
            file.fileName = incognito(file.fileName, currentUserInfo.value.detail.userName)
          }
        }
      }
      annex.list = await res.data.attachmentList.filter((v) => v.isShow)
    } catch (error) {
      throw new Error(error)
    } finally {
      annexLoading.value = false
      // isAnnexLoaded.value = true
    }
  }

  const setIsAnnexLoaded = (val) => {
    isAnnexLoaded.value = val
  }

  /**
   * @description: 设置查询参数
   * @return {*}
   * @author: Lqi
   */
  const setQueryParams = ({
    current = 1,
    size = 10,
    reportSpecialtyFirstCode = listQuery.params.eq.p.reportSpecialtyFirstCode,
    reportSpecialtySecondCode = listQuery.params.eq.p.reportSpecialtySecondCode,
    reportSpecialtyThirdCode = listQuery.params.eq.p.reportSpecialtyThirdCode,
    isQualified = listQuery.params.eq.o.isQualified,
    isAgreen = listQuery.params.eq.o.isAgreen,
    type = listQuery.values.type,
    searchKey = '',
    valuesReportSpecialtyFirstCode = listQuery.values.reportSpecialtyFirstCode,
    valuesReportSpecialtySecondCode = listQuery.values.reportSpecialtySecondCode,
    valuesReportSpecialtyThirdCode = listQuery.values.reportSpecialtyThirdCode
  }) => {
    listQuery.current = current
    listQuery.size = size
    listQuery.params.eq.o.isAgreen = isAgreen
    listQuery.params.eq.o.isQualified = isQualified
    listQuery.params.eq.p.reportSpecialtyFirstCode = reportSpecialtyFirstCode
    listQuery.params.eq.p.reportSpecialtySecondCode = reportSpecialtySecondCode
    listQuery.params.eq.p.reportSpecialtyThirdCode = reportSpecialtyThirdCode
    listQuery.values.type = type
    listQuery.values.searchKey = searchKey
    listQuery.values.reportSpecialtyFirstCode = valuesReportSpecialtyFirstCode
    listQuery.values.reportSpecialtySecondCode = valuesReportSpecialtySecondCode
    listQuery.values.reportSpecialtyThirdCode = valuesReportSpecialtyThirdCode
  }

  /**
   * @description: 设置userId
   * @param {*} second
   * @return {*}
   * @author: Lqi
   */
  const setUserId = (id) => {
    userId.value = id
  }

  /**
   * @description: 总缓存
   * @param {*} data
   * @param {*} reportId
   * @return {*}
   * @author: Lqi
   */
  const _setTotalCache = ({ data, key }, reportId) => {
    // console.log(key, reportId, data)
    // console.log(totalCache)

    // if (!totalCache.length) {
    //   totalCache.push({
    //     reportId: reportId,
    //     data: {
    //       reportForm: {
    //         userInfo: { data: null, error: false },
    //         // 申报信息
    //         report: { data: null, error: false },
    //         // 学历信息
    //         edu: { data: null, error: false },
    //         // 职称情况
    //         rank: { data: null, error: false },
    //         // 学习经历
    //         study: { data: null, error: false },
    //         // 工作情况
    //         work: { data: null, error: false },
    //         // 专业技术工作总结
    //         summary: { data: null, error: false },
    //         // 完成主要专业技术工作情况
    //         finished: { data: null, error: false },
    //         // 承担课题（项目）情况
    //         project: { data: null, error: false },
    //         // 专利情况
    //         patent: { data: null, error: false },
    //         // 表彰奖励
    //         reward: { data: null, error: false },
    //         // 论文著作情况
    //         thesis: { data: null, error: false },
    //         // 参加继续教育和学术活动
    //         learn: { data: null, error: false },
    //         // 年度考核
    //         appraise: { data: null, error: false }
    //       }
    //     }
    //   })
    // }

    // console.log('totalCache1', totalCache)
    for (let item of totalCache) {
      if (item.reportId === reportId) {
        item.data.reportForm[key] = data
      }
    }
    // console.log('totalCache2', totalCache)
    // totalCache.push([{ reportId: reportId, data:  }])
  }

  /**
   * @description: 加载卫生特殊表
   * @return {*}
   * @author: Lqi
   */
  const loadHoSpecialTable = async () => {
    console.log('loadHoSpecialTable')

    try {
      hoSpecial.loading = true
      hoSpecial.score.loading = true
      const score = await getScoreExtendByReportId(reportId.value)
      hoSpecial.score.data = score.data
      hoSpecial.score.loading = false

      hoSpecial.exams.loading = true
      const exams = await getExamScoreByUserId(userId.value)
      hoSpecial.exams.data = exams.data || []
      hoSpecial.exams.loading = false

      hoSpecial.histories.loading = true
      const histories = await getRankSituationByUserId(userId.value)
      hoSpecial.histories.data = histories.data || []
      hoSpecial.histories.loading = false

      // hoSpecial.workload.loading = true
      const workload = await getWorkloadByUserId(reportId.value)
      hoSpecial.workload.data = workload.data
      hoSpecial.workload.loading = false
      hoSpecial.userId = await userId.value
      hoSpecial.loading = false

      const DRG = await getDRGInfo(reportId.value)
      hoSpecial.drg.data = DRG.data
      hoSpecial.drg.loading = false
      hoSpecial.loading = false

      // data4.value =
    } catch (error) {
      console.error(error)
      hoSpecial.score.loading = false
      hoSpecial.exams.loading = false
      hoSpecial.histories.loading = false
      hoSpecial.workload.loading = false
      hoSpecial.loading = false
    }
  }

  return {
    listQuery,
    reviewPage,
    setReviewList,
    reviewListData,
    updateReviewList,
    setReportForm,
    reportId,
    year,
    setSearchBar,
    searchType,
    searchKey,
    searchBar,
    setSearchKey,
    setSearchType,
    getData,
    setReportId,
    preReportId,
    getAnnex,
    annex,
    setFetchLoading,
    fetchLoading,
    reportForm,
    setQueryParams,
    userId,
    setUserId,
    isAnnexLoaded,
    setIsAnnexLoaded,
    annexLoading,
    allIds,
    getAllIds,
    personnelId,
    setPersonnelId,
    personalDetail,
    setPersonalDetail,
    getPersonalDetail,
    setReviewType,
    hoSpecial,
    loadHoSpecialTable,
    initHoSpecial,
    resDataStoreData
  }
})

export function useDataStoreHook() {
  return useDataStore(store)
}
