/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:20:57
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-14 16:40:25
 * @FilePath: /review-front/src/stores/modules/app.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ref, computed } from 'vue'
import { defineStore } from 'pinia'
import store from '@/stores'
import { APIENUM } from '@/config/api'
// import { APIENUM } from '@/config/api'
// import { useTable } from '@/hooks/useTable'

export const useAppStore = defineStore(
  'app',
  () => {
    const reviewType = ref('') // COMMON/HO/EDU/MSM

    const isTour = ref(true)

    const configs = ref({
      isNeedJuryOpinion: 0,
      isSetMessage: 1,
      detailVisible: false,
      leftCurrentKey: '1',
      rightCurrentKey: '1'
    })

    // 基础qpi
    const baseAPI = computed(() => APIENUM[reviewType.value])

    // 全屏loading
    const appLoading = ref(false)

    // 搜索栏
    const searchBar = ref({})

    // 表决按钮文字信息
    const voteBtnText = ref({})

    // 详情页功能配置
    let detailConfig = ref({
      // 字体大小
      opinionFontSize: '14px'
    })

    // 缓存意见数据
    const opinionData = ref({})

    /**
     * @description: 详情页配置内容
     * @param {array} ops
     * @return {*}
     * @author: Lqi
     */
    const setDetailConfig = ({ ...ops }) => {
      detailConfig.value = Object.assign(detailConfig.value, ops)
    }

    const setOpinionData = ({ ...opinions }) => {
      opinionData.value = Object.assign(opinionData.value, opinions)
    }

    /**
     * @description: 配置
     * @param {*} config
     * @return {*}
     * @author: Lqi
     */
    const setConfigs = (config) => {
      configs.value = { ...configs.value, ...config }
    }

    const setTour = (val) => {
      isTour.value = val
    }

    /**
     * @description: 设置评审类型
     * @param {*} value
     * @return {*}
     * @author: Lqi
     */
    const setReviewType = (value) => {
      reviewType.value = value
      // baseAPi.value = APIENUM[reviewType]
    }

    /**
     * @description: 设置表决按钮文字信息
     * @param {*} code
     * @return {*}
     * @author: Lqi
     */
    const setVoteBtnText = (code) => {
      const obj = {
        2901: { 1: '通过', 2: '不通过' },
        2902: { 1: '推荐', 2: '不推荐' }
      }
      voteBtnText.value = obj[+code]
    }

    /**
     * @description: 设置apploading
     * @param {*} loding
     * @return {*}
     * @author: Lqi
     */
    const setAppLoding = (loding) => {
      appLoading.value = loding
    }

    return {
      reviewType,
      searchBar,
      setVoteBtnText,
      setReviewType,
      voteBtnText,
      setAppLoding,
      appLoading,
      configs,
      setConfigs,
      detailConfig,
      setDetailConfig,
      opinionData,
      setOpinionData,
      baseAPI,
      setTour,
      isTour
    }
  },
  {
    persist: true
  }
)
export function useAppStoreHook() {
  return useAppStore(store)
}
