/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:01:36
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 09:51:33
 * @FilePath: /review-front/src/router/permission.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import router from '@/router'
import NProgress from 'nprogress'
// import { getToken } from '@/utils/cache/cookies'
import isWhiteList from '@/config/wihteList'
import { getDictCache, setDictCache } from '@/utils/cache/localStorage'
import { useDictsStoreHook } from '@/stores/modules/dicts'
import { useUserStoreHook } from '@/stores/modules/user'
import { fetchDataList } from '@/api/dict'

const dictArr = [
  'dictArea',
  'dictField',
  'dictHonor',
  'dictJobPro',
  'dictJobTitle',
  'dictLearnPro',
  'dictScience',
  'dictTree'
]
NProgress.configure({ showSpinner: true })

router.beforeEach(async (to, from, next) => {
  if (to.hash) {
    // 如果是锚点跳转，则直接放行
    next()
    return
  }
  // const token = getToken()
  const { isGetDict, setDicts } = useDictsStoreHook()
  const { token } = useUserStoreHook()
  NProgress.start()

  // 判断该用户是否已经登录
  if (!token) {
    // 如果在免登录的白名单中，则直接进入
    console.log(to)

    if (isWhiteList(to)) return next()
    // 其他没有访问权限的页面将被重定向到登录页面
    return next('/login')
  }

  // 如果已经登录，并准备进入 Login 页面，则重定向到主页
  if (to.path === '/login') {
    return next({ path: '/' })
  }

  try {
    if (!isGetDict) {
      const dictKeys = []
      for (let i = 0; i < dictArr.length; i++) {
        const dictKey = dictArr[i]
        const res = getDictCache(dictKey)
        if (!res) {
          dictKeys.push(dictKey)
        }
      }
      const _keys = []

      Promise.all(dictKeys.map((key) => fetchDataList.bind(null, { key })(_keys.push(key)))).then(
        (res) => {
          for (let index = 0; index < res.length; index++) {
            const data = res[index].data
            const dictKey = _keys[index]
            setDictCache(dictKey, data)
          }
        }
      )
      setDicts(true)
    }
  } catch (error) {
    console.warn(error)
  }
  next()
})

router.afterEach(() => {
  NProgress.done()
})
