/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-10-10 15:30:14
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-19 10:05:26
 * @FilePath: /review-front-business/src/router/index.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-22 10:45:04
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 09:49:15
 * @FilePath: /review-front/src/router/index.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { createRouter, createWebHashHistory } from 'vue-router'
import { h } from 'vue'
import Layouts from '@/layouts/index.vue'
import adminLayout from '@/layouts/adminLayout.vue'
import { PieChartOutlined } from '@ant-design/icons-vue'

export const routes = [
  {
    path: '/',
    name: '',
    component: Layouts,
    redirect: 'dashboard',
    children: [
      {
        path: 'dashboard',
        name: 'Dashboard',
        component: () => import('@/views/dashboard/index.vue'),
        meta: { title: '首页' }
      },
      {
        path: 'expert-info',
        name: 'ExpertInfo',
        component: () => import('@/views/info/index.vue'),
        meta: { title: '基础信息' }
      },
      {
        path: 'update-password',
        name: 'UpdatePassword',
        component: () => import('@/views/info/changePassword.vue'),
        meta: { title: '修改密码' }
      },
      {
        path: 'review-list',
        name: 'ReviewList',
        component: () => import('@/views/list/index.vue'),
        meta: { title: '审核列表' }
      }
    ]
  },
  {
    path: '/admin',
    component: adminLayout,
    redirect: '/admin/dashboard',
    meta: { isAdminMenu: true },
    children: [
      {
        path: '/admin/dashboard',
        name: 'AdminDashboard',
        component: () => import('@/views/admin/dashboard/index.vue'),
        meta: { title: '管理员首页', icon: h(PieChartOutlined) }
      },
      {
        path: '/application-acceptance',
        name: 'ApplicationAcceptance',
        meta: { title: '申请管理', icon: h(PieChartOutlined) },
        children: [
          {
            path: '/admin/application-acceptance/unit',
            name: 'UnitAcceptance',
            component: () => import('@/views/admin/acceptance/unit.vue'),
            meta: { title: '单位申请受理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/application-acceptance/personnel',
            name: 'PersonnelAcceptance',
            component: () => import('@/views/admin/acceptance/personnel.vue'),
            meta: { title: '个人申请受理', icon: h(PieChartOutlined) }
          },
        ]
      },
      {
        path: '/admin/review',
        meta: { title: '评审管理', icon: h(PieChartOutlined) },
        children: [
          {
            path: '/admin/review/plan',
            name: 'ReviewPlan',
            component: () => import('@/views/admin/review/plan.vue'),
            meta: { title: '计划管理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/review/group',
            name: 'ReviewGroup',
            component: () => import('@/views/admin/review/group.vue'),
            meta: { title: '分组管理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/review/expert',
            name: 'reviewExpert',
            component: () => import('@/views/admin/review/expert.vue'),
            meta: { title: '专家管理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/review/personnel',
            name: 'ReviewPersonnel',
            component: () => import('@/views/admin/review/personnel.vue'),
            meta: { title: '人员管理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/review/project',
            name: 'ReviewProject',
            component: () => import('@/views/admin/review/project.vue'),
            meta: { title: '项目管理', icon: h(PieChartOutlined) }
          },
          {
            path: '/admin/review/result',
            name: 'ReviewResult',
            component: () => import('@/views/admin/review/result.vue'),
            meta: { title: '评审结果管理', icon: h(PieChartOutlined) }
          }
        ]
      },
      {
        path: '/admin/message',
        meta: { title: '消息管理', icon: h(PieChartOutlined) },
        children: [
          {
            path: '/admin/message/messageManagement',
            name: 'MessageManagement',
            component: () => import('@/views/admin/message/index.vue'),
            meta: { title: '计划管理', icon: h(PieChartOutlined) }
          },
        ]
      }
    ]
  },
  {
    path: '/login',
    name: 'login',
    component: () => import('@/views/login/index.vue'),
    meta: { title: '登录' }
  },
  {
    path: '/adminLogin',
    name: 'adminLogin',
    component: () => import('@/views/login/adminLogin.vue'),
    meta: { title: '管理员登录' }
  },
  {
    path: '/loginObserver',
    name: 'loginObserver',
    component: () => import('@/views/login/loginObserver.vue'),
    meta: { title: '观察员登录' }
  },
  {
    path: '/dashboard',
    name: 'dashboard',
    component: () => import('@/views/dashboard/index.vue'),
    meta: { title: '首页' }
  },
  {
    path: '/reviewList',
    name: 'reviewList',
    component: () => import('@/views/list/index.vue'),
    meta: { title: '评审列表' }
  },
  {
    path: '/signature',
    name: 'signature',
    component: () => import('@/views/signature/index.vue'),
    meta: { title: '签名' }
  },
  {
    path: '/about',
    name: 'about',
    // route level code-splitting
    // this generates a separate chunk (About.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () => import('../views/AboutView.vue')
  }
]
export const router = createRouter({
  history: createWebHashHistory(import.meta.env.BASE_URL),
  routes: routes
})

export default router
