import { useDataStoreHook } from '@/stores/modules/data'
import {
  getYearByReportId,
  getReportOrReview,
  getBasicInfo,
  getCheckedInfo,
  getEduInfo,
  getFinishedInfo,
  getLearnInfo,
  getPatentInfo,
  getProjectInfo,
  getRankInfo,
  getResultInfo,
  getRewardInfo,
  getThesisInfo,
  getStudyInfo,
  getWorkInfo
} from '@/api/user/reportForm'
export default {
  setup() {
    const useDataStore = useDataStoreHook()
    const { reportId, year, setReportForm } = useDataStore

    const loadData = async () => {
      await getYear()
      await getReport()
      await getInfo()
      await getEdu()
      await getRank()
      await getStudy()
      await getWrok()
      await getSummary()
      await getFinished()
      await getProject()
      await getPatentt()
      await getReward()
      await getThesis()
      await geLearn()
      await getCheck()
    }

    const getYear = async () => {
      try {
        const res = await getYearByReportId({ reportId: reportId })
        useDataStore.year = res
      } catch (error) {
        console.warn(error)
      }
    }

    const getReport = async () => {
      try {
        const res = await getReportOrReview(reportId)
        setReportForm('report', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('report', {}, true)
      }
    }

    const getInfo = async () => {
      try {
        const res = await getBasicInfo(reportId, year)
        setReportForm('userInfo', res.data)
      } catch (error) {
        setReportForm('userInfo', {}, true)
      }
    }

    const getEdu = async () => {
      try {
        const res = await getEduInfo(reportId, year)
        setReportForm('edu', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('edu', {}, true)
      }
    }

    const getRank = async () => {
      try {
        const res = await getRankInfo(reportId, year)
        setReportForm('rank', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('rank', {}, true)
      }
    }

    const getStudy = async () => {
      try {
        const res = await getStudyInfo(reportId, year)
        setReportForm('study', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('study', {}, true)
      }
    }

    const getWrok = async () => {
      try {
        const res = await getWorkInfo(reportId, year)
        setReportForm('wrok', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('wrok', {}, true)
      }
    }

    const getSummary = async () => {
      try {
        const res = await getResultInfo(reportId, year)
        setReportForm('getsummary', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('getsummary', {}, true)
      }
    }

    const getFinished = async () => {
      try {
        const res = await getFinishedInfo(reportId, year)
        setReportForm('finished', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('finished', {}, true)
      }
    }

    const getProject = async () => {
      try {
        const res = await getProjectInfo(reportId, year)
        setReportForm('project', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('project', {}, true)
      }
    }

    const getPatentt = async () => {
      try {
        const res = await getPatentInfo(reportId, year)
        setReportForm('patent', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('patent', {}, true)
      }
    }

    const getReward = async () => {
      try {
        const res = await getRewardInfo(reportId, year)
        setReportForm('reward', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('reward', {}, true)
      }
    }

    const getThesis = async () => {
      try {
        const res = await getThesisInfo(reportId, year)
        setReportForm('thesis', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('thesis', {}, true)
      }
    }

    const geLearn = async () => {
      try {
        const res = await getLearnInfo(reportId, year)
        setReportForm('learn', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('learn', {}, true)
      }
    }

    const getCheck = async () => {
      try {
        const res = await getCheckedInfo(reportId, year)
        setReportForm('appraise', res.data.report)
      } catch (error) {
        console.warn(error)
        setReportForm('appraise', {}, true)
      }
    }

    return {
      loadData,
      getYear,
      getReport,
      getInfo,
      getCheck,
      getEdu,
      getFinished,
      getRank,
      getStudy,
      getWrok,
      getSummary,
      getProject,
      getPatentt,
      getReward,
      getThesis,
      geLearn
    }
  }
}
