/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-22 10:45:04
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 09:46:16
 * @FilePath: /review-front/src/main.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import 'normalize.css'
import './assets/main.scss'

import { createApp } from 'vue'
import App from './App.vue'
import store from '@/stores'
import router from '@/router'
import { message, notification } from 'ant-design-vue'
// import MakeitCaptcha from 'makeit-captcha'
// import 'makeit-captcha/dist/captcha.min.css'
import { filters } from '@/utils/filter'
import { loadingFadeOut } from 'virtual:app-loading'

import './router/permission'
import './assets/media.scss'

const app = createApp(App)
app.config.globalProperties.$message = message
app.config.globalProperties.$notification = notification
app.config.globalProperties.$filters = filters

app.use(store).use(router)
// app.use(MakeitCaptcha)

router.isReady().then(() => {
  app.mount('#app')
  console.log(router.getRoutes())

  setTimeout(() => {
    loadingFadeOut()
  }, 800)
})
