//获取申报表
import { ref } from 'vue'
import { useDataStoreHook } from '@/stores/modules/data'
import { incognito } from '@/utils'
import { cloneDeep } from 'lodash-es'
import {
  getYearByReportId,
  getReportOrReview,
  getBasicInfo,
  getCheckedInfo,
  getEduInfo,
  getFinishedInfo,
  getLearnInfo,
  getPatentInfo,
  getProjectInfo,
  getRankInfo,
  getResultInfo,
  getRewardInfo,
  getThesisInfo,
  getStudyInfo,
  getWorkInfo
} from '@/api/user/reportForm'
const useDataStore = useDataStoreHook()
const loading = ref(false)
const reloadLoading = ref(false)
const isLoaded = ref(false)
const loadArr = ref([])
const reportFormLoading = ref(false)
const userInfo = ref({})

const loadData = async () => {
  try {
    useDataStore.setFetchLoading(true)
    await getInfo()
    await getReport()
    await getEdu()
    await getRank()
    await getStudy()
    await getWrok()
    await getSummary()
    await getFinished()
    await getProject()
    await getPatent()
    await getReward()
    await getThesis()
    await geLearn()
    await getCheck()
    useDataStore.setFetchLoading(false)
  } catch (error) {
    console.error(error)
  } finally {
    useDataStore.setFetchLoading(false)
  }
}

const setLoading = (value, type = 'load') => {
  if (type === 'load') {
    loading.value = value
  } else {
    reloadLoading.value = value
  }
}

const setIsLoaded = (val) => {
  isLoaded.value = val
}

/**
 * @description: 获取申报年份
 * @return {*}
 * @author: Lqi
 */
export const getYear = async () => {
  try {
    const res = await getYearByReportId({ reportId: useDataStore.reportId })
    // console.log('getYear', res)
    useDataStore.year = res.data
  } catch (error) {
    console.warn(error)
  }
}

/**
 * @description: 获取申报信息
 * @return {*}
 * @author: Lqi
 */
const getReport = async () => {
  try {
    reloadLoading.value = true
    const res = await getReportOrReview(useDataStore.reportId)
    // 匿名
    if (JSON.parse(localStorage.getItem('plan')).groupInfo.isIncognito) {
      res.data.review.unitMessage = incognito()
      res.data.review.unitAuditOpinion = incognito(
        res.data.review.unitAuditOpinion,
        userInfo.value.userName
      )
      res.data.review.managerAuditOpinion = incognito(
        res.data.review.managerAuditOpinion,
        userInfo.value.userName
      )
      res.data.review.bureauDistrictAuditOpinion = incognito(
        res.data.review.bureauDistrictAuditOpinion,
        userInfo.value.userName
      )
      res.data.review.bureauCityAuditOpinion = incognito(
        res.data.review.bureauCityAuditOpinion,
        userInfo.value.userName
      )
    }
    useDataStore.setReportForm('id', useDataStore.reportId, useDataStore.reportId, res.code !== 200)
    useDataStore.setReportForm('report', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('report', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取基础信息
 * @return {*}
 * @author: Lqi
 */
const getInfo = async () => {
  try {
    reloadLoading.value = true
    const res = await getBasicInfo(useDataStore.reportId, useDataStore.year)
    userInfo.value = cloneDeep(res.data)
    // 匿名
    if (JSON.parse(localStorage.getItem('plan')).groupInfo.isIncognito) {
      res.data.userName = incognito()
      res.data.paperworkNumber = incognito()
      res.data.security = ''
      res.data.oldName = incognito()
      // res.data.photoImageUrl
    }
    useDataStore.setReportForm('userInfo', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    useDataStore.setReportForm('userInfo', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取学历信息
 * @return {*}
 * @author: Lqi
 */
const getEdu = async () => {
  try {
    reloadLoading.value = true
    const res = await getEduInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getEdu', res)
    useDataStore.setReportForm('edu', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('edu', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取职称信息
 * @return {*}
 * @author: Lqi
 */
const getRank = async () => {
  try {
    reloadLoading.value = true
    const res = await getRankInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getRank', res)
    useDataStore.setReportForm('rank', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('rank', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取学习经历
 * @return {*}
 * @author: Lqi
 */
const getStudy = async () => {
  try {
    reloadLoading.value = true
    const res = await getStudyInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getStudy', res)

    useDataStore.setReportForm('study', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('study', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取工作信息
 * @return {*}
 * @author: Lqi
 */
const getWrok = async () => {
  try {
    reloadLoading.value = true
    const res = await getWorkInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getWrok', res)
    useDataStore.setReportForm('work', res.data, useDataStore.reportId, res.code !== 200) //res.code !== 200
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('work', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取总结
 * @return {*}
 * @author: Lqi
 */
const getSummary = async () => {
  try {
    reloadLoading.value = true
    const res = await getResultInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getSummary', res)

    if (JSON.parse(localStorage.getItem('plan')).groupInfo.isIncognito) {
      res.data.content = incognito(res.data.content, userInfo.value.userName)
    }
    useDataStore.setReportForm('summary', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('summary', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 完成技术工作
 * @return {*}
 * @author: Lqi
 */
const getFinished = async () => {
  try {
    reloadLoading.value = true
    const res = await getFinishedInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getFinished', res)
    useDataStore.setReportForm('finished', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('finished', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取项目
 * @return {*}
 * @author: Lqi
 */
const getProject = async () => {
  try {
    reloadLoading.value = true
    const res = await getProjectInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getProject', res)
    useDataStore.setReportForm('project', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('project', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取专利信息
 * @return {*}
 * @author: Lqi
 */
const getPatent = async () => {
  try {
    reloadLoading.value = true
    const res = await getPatentInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getPatent', res)
    useDataStore.setReportForm('patent', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('patent', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取奖励信息
 * @return {*}
 * @author: Lqi
 */
const getReward = async () => {
  try {
    reloadLoading.value = true
    const res = await getRewardInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getReward', res)
    useDataStore.setReportForm('reward', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('reward', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取论文著作情况
 * @return {*}
 * @author: Lqi
 */
const getThesis = async () => {
  try {
    reloadLoading.value = true
    const res = await getThesisInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getThesis', res)
    useDataStore.setReportForm('thesis', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('thesis', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取继续教育
 * @return {*}
 * @author: Lqi
 */
const geLearn = async () => {
  try {
    reloadLoading.value = true
    const res = await getLearnInfo(useDataStore.reportId, useDataStore.year)
    // console.log('geLearn', res)
    useDataStore.setReportForm('learn', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('learn', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

/**
 * @description: 获取年度考核
 * @return {*}
 * @author: Lqi
 */
const getCheck = async () => {
  try {
    reloadLoading.value = true
    const res = await getCheckedInfo(useDataStore.reportId, useDataStore.year)
    // console.log('getCheck', res)
    useDataStore.setReportForm('appraise', res.data, useDataStore.reportId, res.code !== 200)
    loadArr.value.push(true)
  } catch (error) {
    console.warn(error)
    useDataStore.setReportForm('appraise', {}, useDataStore.reportId, true)
  } finally {
    reloadLoading.value = false
  }
}

export function useReportForm() {
  return {
    loadData,
    getYear,
    getReport,
    getInfo,
    getCheck,
    getEdu,
    getFinished,
    getRank,
    getStudy,
    getWrok,
    getSummary,
    getProject,
    getPatent,
    getReward,
    getThesis,
    geLearn,
    loading,
    setLoading,
    reloadLoading,
    setIsLoaded,
    reportFormLoading
  }
}
