/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-15 16:33:41
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-10 15:35:43
 * @FilePath: /review-front/src/hooks/useDetail.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { reactive, ref, computed } from 'vue'
import { useAppStoreHook } from '@/stores/modules/app'
import { usePlanStoreHook } from '@/stores/modules/plan'
import { useDictsStoreHook } from '@/stores/modules/dicts'

const useAppStore = useAppStoreHook()
const usePlanStore = usePlanStoreHook()
const useDictsStore = useDictsStoreHook()
const leftTabs = reactive({
  COMMON: [
    { key: '1', tab: '申报表', name: 'reportForm' },
    { key: '2', tab: '附件材料', name: 'annex' }
  ],
  EDU: [
    { key: '1', tab: '申报表', name: 'reportForm' },
    { key: '2', tab: '附件材料', name: 'annex' }
  ]
})

const configState = ref({
  // 复制意见
  copyOpinion: true,
  // 详情页弹框
  detailVisible: false,
  // 是否修改了意见为保存
  isEditNotSave: false,
  // 详情左边当前tabs的key
  leftCurrentKey: '1',
  // 详情右边当前tabs的key
  rightCurrentKey: '1'
})

const opinionSelectOptions = reactive({
  qualifiedOptions: useDictsStore.getDictByParentId('dictTree', 645),
  agreenOptions: useDictsStore.getDictByParentId('dictTree', 649)
})

const setConfigState = ({ ...configs }) => {
  configState.value = Object.assign(configState.value, configs)
}

/**
 * @description: 详情页分屏左边tab显示
 * @param {*} computed
 * @return {*}
 * @author: Lqi
 */
const leftTabsList = computed(() => leftTabs[useAppStore.reviewType])

const rightTabs = reactive([
  { key: '1', tab: '意见', name: 'opinion' },
  { key: '2', tab: '打分', name: 'scoring' }
  // { key: '3', tab: '表决', name: 'vote' }
])
const rightTabsList = computed(() => {
  const type = usePlanStore.groupInfo.type
  let _list = rightTabs.filter((v) => {
    if (!usePlanStore.groupInfo.isSetMessage) {
      return v.name !== 'opinion'
    }
    if (type < 1) {
      return v.name !== 'scoring'
    }
    if (type >= 1) {
      return v.name !== 'vote'
    }
    return true
  })
  console.log('rightTabsList', type, rightTabsList)

  return _list
})

export function useDetailHook() {
  return { leftTabsList, rightTabsList, configState, setConfigState, opinionSelectOptions }
}
