/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-06 15:01:02
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-11 14:53:02
 * @FilePath: /review-front/src/api/info.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'
/**
 * @description: 获取专家基本信息
 * @return {*}
 * @author: Lqi
 */
export function getExpertInfo() {
  return JSON.parse(localStorage.getItem('user'))
}

/**
 * @description: 专家设置基本信息
 * @return {*}
 * @author: Lqi
 */
export function setExpertInfo(data) {
  return request({
    url: '/api-evaluation/evaluation/expertUser/updateExpertUserAndInfo',
    method: 'post',
    data
  })
}

/**
 * @description: 专家获取评审记录
 * @return {*}
 * @author: Lqi
 */
export function getReviewReconds() {}

/**
 * @description: 专家登录完获取配置列表
 * @return {*}
 * @author: Lqi
 */
export function getConfigList() {
  return request({
    url: '/api-evaluation/evaluation/expertPlanGroupConf/getExpertPlanGroupConfList',
    method: 'get'
  })
}

/**
 * @description: 查询单位
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getUnitList(data) {
  return request({
    url: '/api-system/unit/common/findUnitPage',
    method: 'post',
    data
  })
}

/**
 * @description: 获取专家信息
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getExpert(data) {
  return request({
    url: '/api-evaluation/evaluation/expertUserInfo/selectExperUserInfo',
    method: 'post',
    data
  })
}
