/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-06 17:00:49
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-12 15:00:44
 * @FilePath: /review-front/src/api/details.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 详情页
import request from '@/utils/request'
import { useAppStoreHook } from '@/stores/modules/app'

/**
 * @description: 获取申报人详细信息
 * @param {*} id
 * @param {*} planId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function getReviewDetail(id, planId, groupId) {
  return request({
    url: `/api-evaluation/${
      useAppStoreHook().baseAPI
    }/expert/expertUser/reviewListDataById/${id}/${planId}/${groupId}`,
    method: 'get'
  })
}

/**
 * @description: 获取附件
 * @param {*} userId
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function enclosure(userId, year) {
  return request({
    url: '/api-review/report/attachment/file/list',
    handle: { systemId: 2 },
    method: 'post',
    params: { year, userId }
  })
}

/**
 * @description: 获取专家意见
 * @return {*}
 * @author: Lqi
 */
export function getOpinion(personalId) {
  return request({
    url:
      '/api-evaluation/' +
      useAppStoreHook().baseAPI +
      '/expert/getExpertUserReviewOpinion/' +
      personalId,
    method: 'get'
  })
}

/**
 * @description: 设置专家意见
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function setOpinion(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/expertUserSetMainOpinion',
    method: 'post',
    data
  })
}

/**
 * @description: 专家打分
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function setScore(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/expertUserScoreReview',
    method: 'post',
    data
  })
}

/**
 * @description: 辅审同意意见
 * @param {*} personalId
 * @return {*}
 * @author: Lqi
 */
export function auxiliarySetAgree(personalId) {
  return request({
    url:
      '/api-evaluation/' +
      useAppStoreHook().baseAPI +
      '/expert/expertUserSetAuxiliaryOpinion/' +
      personalId,
    method: 'get'
  })
}

/**
 * @description: 获取打分信息
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
export function getScoreInfo(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/getExpertUserScoreInfo',
    method: 'post',
    data
  })
}

/**
 * @description: 获取主审打分信息
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getMainScoreInfo(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/getExpertUserMainScoreInfo',
    method: 'post',
    data
  })
}

/**
 * @description: 获取打分模板和结果
 * @param {*} personnelId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function getTemplateTreeResult(personnelId, groupId) {
  return request({
    url: `/api-evaluation/api/template/expertUserGetTemplateTreeAndEvaluationResult/${personnelId}/${groupId}`
  })
}

/**
 * @description: 获取打分结果
 * @param {*} personnelId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function getTemplateTreeScoreResult(type, personnelId, groupId) {
  return request({
    url: `/api-evaluation/api${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/template/expertUserGetTemplateTreeScore/${personnelId}/${groupId}`
  })
}

/**
 * @description: 获取会议文件列表
 * @param {*} type
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getReviewFileList(type, data) {
  let urlStr =
    type === 'EDU'
      ? 'getEduUploadFileList'
      : type === 'COMMON'
      ? 'getCommonUploadFileList'
      : 'getHOUploadFileList'

  return request({
    url: `/api-evaluation/file/${urlStr}`,
    method: 'post',
    data
  })
}
