/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-12-12 16:18:59
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-17 09:33:49
 * @FilePath: /review-front/src/api/admin/plan.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'

/**
 * @description: 获取列表
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function fetchList(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/plan/adminPage`,
    method: 'post',
    data
  })
}

/**
 * @description: 设置状态
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function setStatusObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/plan/adminSetStatus`,
    method: 'post',
    data
  })
}

/**
 * @description: 创建
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function createObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/plan/adminAdd`,
    method: 'post',
    data
  })
}

/**
 * @description: 更新
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function updateObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/plan/adminModify`,
    method: 'post',
    data
  })
}

/**
 * @description: 删除
 * @param {*} id
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function deleteObj(id, type) {
  return request({
    url:
      `/api-evaluation/evaluation${
        type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
      }/plan/adminDelete/` + id,
    method: 'get'
  })
}

/**
 * @description: 获取公共评委会附件列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getCommonUploadFileList(data) {
  return request({
    url: '/api-evaluation/file/getCommonUploadFileList',
    method: 'post',
    data
  })
}

/**
 * @description: 获取教育评委会附件列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getEduUploadFileList(data) {
  return request({
    url: '/api-evaluation/file/getEduUploadFileList',
    method: 'post',
    data
  })
}

/**
 * @description: 获取卫生评委会附件列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getHOUploadFileList(data) {
  return request({
    url: '/api-evaluation/file/getHOUploadFileList',
    method: 'post',
    data
  })
}

/**
 * @description: 删除评委会附件列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function deleteEvaluationFile(data) {
  return request({
    url: '/api-evaluation/file/deleteEvaluationFile',
    method: 'post',
    data
  })
}

/**
 * @description: 获取计划列表
 * @param {*} unitId
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getPlanList(unitId, type) {
  return request({
    url:
      `/api-evaluation/evaluation${
        type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
      }/plan/adminGetPlan/` + unitId,
    method: 'get'
  })
}
