import request from '@/utils/request'

/**
 * @description: 获取分组信息列表
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function fetchList(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/adminPage`,
    method: 'post',
    data
  })
}

export function getGroupListByPlan(planId, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/getGroupByPlanId/${planId}`,
    method: 'get'
  })
}

/**
 * @description: 创建
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function createObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/adminAdd`,
    method: 'post',
    data
  })
}

/**
 * @description: 删除
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function deleteObj(id, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/adminDelete/${id}`
  })
}

/**
 * @description: 修改
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function updateObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/adminModify`,
    method: 'post',
    data
  })
}

/**
 * @description: 修改状态
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function setStatusObj(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/setStatus`,
    method: 'post',
    data
  })
}

/**
 * @description: 获取打分模板
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getScoreTemplate(unitId) {
  return request({
    url: `/api-evaluation/evaluation/scoringTemplate/adminGetOptions${unitId ? '/' + unitId : ''}`,
    method: 'get'
  })
}

/**
 * @description: 创建缓存
 * @param {*} planId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function createCache(planId, groupId, type) {
  return request({
    url: `/api-evaluation/api${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/expert/createRedisAndVoteByPlanIdAndGroupId/${planId}/${groupId}`,
    method: 'get'
  })
}

/**
 * @description: 清除缓存
 * @param {*} planId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function deleteCache(planId, groupId, type) {
  return request({
    url: `/api-evaluation/api${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/expert/clearVoteRedisByPlanIdAndGroupId/${planId}/${groupId}`,
    method: 'get'
  })
}

/**
 * @description: 清除数据库投票数据
 * @param {*} planId
 * @param {*} groupId
 * @return {*}
 * @author: Lqi
 */
export function deleteDataBaseVotes(planId, groupId, type) {
  return request({
    url: `/api-evaluation/api${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/expert/clearVoteByPlanIdAndGroupId/${planId}/${groupId}`,
    method: 'get'
  })
}
