/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-10-24 10:27:05
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-24 17:38:59
 * @FilePath: /review-front/vite/plugins.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import vue from '@vitejs/plugin-vue'
import visualizer from 'rollup-plugin-visualizer'
import { compression } from 'vite-plugin-compression2'
import Components from 'unplugin-vue-components/vite'
import AppLoading from 'vite-plugin-app-loading'
import { loadEnv } from 'vite'
import { AntDesignVueResolver } from 'unplugin-vue-components/resolvers'
import VueDevTools from 'vite-plugin-vue-devtools'

export default function createVitePlugins(mode) {
  const viteEnv = loadEnv(mode, process.cwd())
  const vitePlugins = [
    vue(),
    compression(),
    Components({
      resolvers: [
        AntDesignVueResolver({
          importStyle: false // css in js
        })
      ]
    }),
    visualizer({ open: true }),
    viteEnv.VITE_OPEN_DEVTOOLS === 'true' && VueDevTools(),
    AppLoading('loading.html')
  ]
  return vitePlugins
}
