/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-22 14:20:06
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-24 11:06:03
 * @FilePath: /review-front/vite.config.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
// import externalGlobals from 'rollup-plugin-external-globals'
import createVitePlugins from './vite/plugins'

// const globals = externalGlobals({
//   antvG2: '@antv/g2'
// })

// https://vitejs.dev/config/
export default defineConfig(({ mode, command }) => {
  return {
    base: '/review/',
    plugins: [createVitePlugins(mode, command === 'build')],
    resolve: {
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url))
      }
    },
    build: {
      minify: 'terser',
      // terserOptions: {
      //   compress: {
      //     drop_console: true,
      //     drop_debugger: true
      //   }
      // },
      rollupOptions: {
        output: {
          chunkFileNames: 'js/[name]-[hash].js',
          entryFileNames: 'js/[name]-[hash].js',
          assetFileNames: '[ext]/[name]-[hash].[ext]',
          manualChunks(id) {
            if (id.includes('node-modules')) {
              return id.toString().split('node_modules/')[1].split('/')[0].toString()
            }
          }
        }
      }
    },
    server: {
      host: 'localhost',
      port: 8088,
      hmr: true
    }
  }
})
