/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-22 14:43:28
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-11-25 10:25:43
 * @FilePath: /review-front/src/utils/axios.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import axios from 'axios'
// import store from '@/stores'
import { removeToken } from '@/utils/cache/cookies'
import { ExclamationCircleOutlined } from '@ant-design/icons-vue'
import { useUserStoreHook } from '@/stores/modules/user'
import { message as $message, Modal } from 'ant-design-vue'
import { createVNode, ref } from 'vue'
import { API_BASE_URL } from '@/config/url'
// import Cookies from 'js-cookie'

const errorQueue = ref([]) // 存储已经显示过的错误消息
const errorDuration = 3000 // 错误消息的持续时间
const handleError = (eMsg) => {
  if (!errorQueue.value.includes(eMsg)) {
    errorQueue.value.push(eMsg)
    $message.error({
      content: eMsg,
      duration: errorDuration / 1000,
      onClose: () => {
        const index = errorQueue.value.indexOf(eMsg)
        if (index > -1) {
          errorQueue.value.splice(index, 1) // 移除已关闭的消息
        }
      }
    })
  }
}

// axios.defaults.withCredentials = true

// 转换请求
const service = axios.create({
  baseURL: API_BASE_URL,
  timeout: 20000 // 请求延时
  // withCredentials: true
})

const hash = window.location.hash
const queryString = hash.includes('?') ? hash.split('?')[1] : ''
const queryParams = new URLSearchParams(queryString)
service.interceptors.request.use(
  (config) => {
    // Cookies.get('Access-Token')
    // const queryParams = new URLSearchParams(window.location.search)

    const QPtoken = queryParams.get('token')
    const { token } = useUserStoreHook()
    if (token || QPtoken) {
      config.headers['access_token'] =
        token || QPtoken || JSON.parse(localStorage.getItem('user')).token
      config.headers['system'] = 2
      config.headers['Cookie'] = token
    }
    return config
  },
  (error) => {
    handleError(error.message)
    console.log('interceptors', error)
    Promise.reject(error)
  }
)

service.interceptors.response.use(
  (response) => {
    const res = response.data
    if (res.code === 400 && res.message.includes('其他地方登录')) {
      Modal.warning({
        title: '异地登录',
        icon: createVNode(ExclamationCircleOutlined),
        content: createVNode(
          'div',
          { style: 'color:red;' },
          '您的账号已在其他地方登录，请重新登录！如不是您自己的操作，请及时修改密码！'
        ),
        onOk() {
          console.log('OK')
          removeToken()
          window.location.reload()
        }
      })
    } else if (res.code === 8002) {
      Modal.warning({
        title: '登录过期',
        icon: createVNode(ExclamationCircleOutlined),
        content: createVNode('div', { style: 'color:red;' }, '您的账号登录已过期，请重新登录！'),
        okText: '重新登录',
        onOk() {
          removeToken()
          window.location.reload()
        }
      })
    }
    // if (res.code === 400) {
    //   setTimeout(() => {
    //     window.location.href = '/review/dashboard'
    //   }, 500)
    // }
    if (res.code !== 200) {
      // console.log('!200', res.message)
      // $message.error(res.message)
      handleError(res.message)
      // showErrorMessage(res.message)
      // messageApi.error(res.message)
      console.log('!200', res)

      throw res
    }
    return Promise.resolve(response.data)
  },
  (error) => {
    if (error.message.includes('timeout')) {
      error.message = '当前请求人数过多，请求服务器超时，请稍后刷新重试!'
    } else if (error.message.includes('Network Error')) {
      error.message = '网络请求错误，请稍后刷新重试!'
    }
    // store.dispatch('setAppLoading', false)
    handleError(error.message)
    console.log('interceptors', error.message)
    return Promise.reject(error)
  }
)

export default service
