/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-09-03 15:50:34
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-16 16:51:11
 * @FilePath: /review-front/src/utils/index.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// const isIncognito =
//   localStorage.getItem('plan') && JSON.parse(localStorage.getItem('plan')).groupInfo.isIncognito

/**
 * @description: 设置匿名
 * @param {*} content 内容
 * @param {*} val 关键字
 * @param {*} options isMain isAuxiliary hasShowDetailPower
 * @return {*}
 * @author: Lqi
 */
export const incognito = (content, val = '', symbol = '***') => {
  // if (!isIncognito) return content
  if (!val) return symbol
  const regex = new RegExp(val, 'gi')
  return content.replace(regex, symbol)
}

/**
 * @description: 时间
 * @return {*}
 * @author: Lqi
 */
export const clock = () => {
  const now = new Date()
  const hours = String(now.getHours()).padStart(2, '0')
  const minutes = String(now.getMinutes()).padStart(2, '0')
  const seconds = String(now.getSeconds()).padStart(2, '0')
  return `${hours}:${minutes}:${seconds}`
}

/**
 * @description: 周
 * @return {*}
 * @author: Lqi
 */
export const week = () => {
  const now = new Date()
  const weekday = now.getDay()
  const days = ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六']
  return days[weekday]
}

// export const incognito = (content, val = '', options) => {
//   let result = content
//   const symbol = '***'
//   const regex = new RegExp(val, 'gi')
//   console.log('isIncognito', isIncognito)
//   console.log('options.isMain', options.isMain)
//   console.log('options.isAuxiliary', options.isAuxiliary)
//   console.log('options.hasShowDetailPower', options.hasShowDetailPower)

//   // 1. 打开匿名 && (是主审 || 是辅审) 2.打开匿名 && 是主审 && 是辅审 && hasShowDetailPower
//   if (
//     !isIncognito ||
//     (isIncognito && (options.isMain || options.isAuxiliary)) ||
//     (isIncognito && !options.isMain && !options.isAuxiliary && options.hasShowDetailPower)
//   ) {
//     return content
//   } else if (isIncognito && (!val || !options)) {
//     result = symbol
//   } else if (isIncognito && !options.isMain && !options.isAuxiliary) {
//     // 打开匿名 && 不是主审 && 不是辅审
//     result = content.replace(regex, symbol)
//   }
//   return result
// }
