/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:12:12
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-08-07 11:48:27
 * @FilePath: /review-front/src/utils/cache/localStorage.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useDictsStoreHook } from '@/stores/modules/dicts'
const userInfoKey = 'userInfo'
const { setDicts } = useDictsStoreHook()

/**
 * @description: 获取用户本地信息
 * @return {*}
 * @author: Lqi
 */
export function getLsUserInfo() {
  try {
    const userInfo = localStorage.getItem(userInfoKey)
    return JSON.parse(userInfo)
  } catch (e) {
    return {}
  }
}

/**
 * @description: 本地字典
 * @param {*} dictKey
 * @param {*} format
 * @return {*}
 * @author: Lqi
 */
export function getDictCache(dictKey, format = false) {
  const res = JSON.parse(localStorage.getItem(dictKey))
  try {
    // 是否需要格式化树形
    return !format ? res : buildTree(res, dictKey)
  } catch (error) {
    return null
  }
}

/**
 * @description: 缓存本地字典
 * @param {*} dictKey
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function setDictCache(dictKey, data) {
  // 缓存本地字典数据
  localStorage.setItem(dictKey, JSON.stringify(data))
  // 缓存字典树到内存
  setDicts(dictKey, buildTree(data))
}

export function removeDictCache(dictKey) {
  return localStorage.removeItem(dictKey)
}

/**
 * @description: 组建树形字典树 测试用时损耗4ms以内
 * @return {*}
 * @author: Lqi
 */
function buildTree(dicts) {
  if (!dicts) return
  // 格式化树形结构
  const _tree = []
  const _map = {}

  try {
    // console.log(dicts)
    dicts.forEach((d) => {
      _map[d.id] = { ...d, children: [] }
    })
    // dicts.sort((a, b) => a.id - b.id)

    // 遍历数据，将每个节点添加到其父节点的children数组中
    dicts.forEach((d) => {
      if (d.parentId !== 0) {
        const parent = _map[d.parentId]
        if (parent) {
          parent.children.push(_map[d.id])
          parent.children.sort((a, b) => a.code - b.code)
        }
      } else {
        _tree.push(_map[d.id])
      }
    })

    // 删除叶子节点的children属性以及children为空的属性，满足element的组件的数据需求
    cleanTree(_tree)

    return _tree
  } catch (e) {
    throw new Error(e)
  }
}

/**
 * @description: 清理属性数据
 * @param {*} tree
 * @return {*}
 * @author: Lqi
 */
function cleanTree(tree) {
  tree.forEach((node) => {
    if (node?.children?.length === 0) {
      delete node.children
    } else {
      cleanTree(node.children)
    }
  })
}
