/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:38:45
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-10 16:39:56
 * @FilePath: /review-front/src/stores/modules/plan.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ref } from 'vue'
import { defineStore } from 'pinia'
import store from '@/stores'
import { getConfigList } from '@/api/user/info'

export const usePlanStore = defineStore(
  'plan',
  () => {
    const configInfoList = ref({})

    const planInfo = ref({})
    const groupInfo = ref({})

    /**
     * @description: 设置计划信息
     * @param {*} value
     * @return {*}
     * @author: Lqi
     */
    const setPlanInfo = (value) => {
      planInfo.value = value
    }

    /**
     * @description: 设置分组信息
     * @param {*} value
     * @return {*}
     * @author: Lqi
     */
    const setGroupInfo = (value) => {
      groupInfo.value = value
    }

    const getConfigInfoList = async () => {
      const res = await getConfigList()
      console.log('getConfigInfo', res.data)
      configInfoList.value = res.data.sort((a, b) => {
        return b.status - a.status
      })
    }

    return {
      planInfo,
      groupInfo,
      configInfoList,
      setGroupInfo,
      setPlanInfo,
      getConfigInfoList
    }
  },
  {
    persist: true
  }
)

export function usePlanStoreHook() {
  return usePlanStore(store)
}
