/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 11:42:33
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-09-05 08:53:33
 * @FilePath: /review-front/src/stores/modules/dicts.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ref, reactive } from 'vue'
import store from '@/stores'
import { defineStore } from 'pinia'
import { getDictCache } from '@/utils/cache/localStorage'
export const useDictsStore = defineStore('dicts', () => {
  const isGetDict = ref(false)
  const dicts = reactive({
    dictTree: getDictCache('dictTree', true) || [],
    dictJobPro: getDictCache('dictJobPro', true) || [],
    dictScience: getDictCache('dictScience', true) || [],
    dictArea: getDictCache('dictArea', true) || [],
    dictLearnPro: getDictCache('dictLearnPro', true) || [],
    dictField: getDictCache('dictField', true) || [],
    dictHonor: getDictCache('dictHonor', true) || [],
    dictJobTitle: getDictCache('dictJobTitle', true) || []
  })

  const setDicts = async (dictKey, data) => {
    dicts[dictKey] = data
  }

  /**
   * @description:
   * @param {*} key dictTree
   * @param {*} pId
   * @return {*}
   * @author: Lqi
   */
  const getDictByParentId = (key, pId) => {
    return dicts[key].filter((v) => v.id === pId)[0].children
  }

  return { isGetDict, setDicts, dicts, getDictByParentId }
})

export function useDictsStoreHook() {
  return useDictsStore(store)
}
