/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-13 14:42:47
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-30 15:41:14
 * @FilePath: /review-front/src/hooks/useTableConfig.js
 * @Description: table list render hook
 */
import { reactive, computed } from 'vue'
import { useAppStoreHook } from '@/stores/modules/app'
const { reviewType } = useAppStoreHook()

const TABLE_COLUMNS = reactive({
  COMMON: [
    { title: '编号', dataIndex: 'number', key: 'number', fixed: 'feft', width: 120 },
    { title: '结果', dataIndex: 'expertResult', key: 'expertResult', fixed: 'feft', width: 80 },
    { title: '分数', dataIndex: 'sort', key: 'sort', width: 80 },
    { title: '姓名', dataIndex: 'userName', key: 'userName', width: 120 },
    { title: '单位', dataIndex: 'unitName', key: 'unitName', width: 300 },
    { title: '现从事专业', dataIndex: 'engagePro', key: 'engagePro', width: 280 },
    { title: '申报专业', dataIndex: 'reportPro', key: 'reportPro', width: 280 },
    { title: '申报职称', dataIndex: 'reportRank', key: 'reportRank', width: 280 },
    { title: '申报等级', dataIndex: 'reportLevel', key: 'reportLevel', width: 120 },
    { title: '操作', dataIndex: 'operation', key: 'operation', fixed: 'right', width: 500 }
  ],
  EDU: [
    { title: '编号', dataIndex: 'number', key: 'number', width: 120 },
    { title: '结果', dataIndex: 'expertResult', key: 'expertResult', fixed: 'feft', width: 80 },
    { title: '学科组得分', dataIndex: 'sort', key: 'sort', fixed: 'feft', width: 110 },
    { title: '姓名', dataIndex: 'userName', key: 'userName', width: 100 },
    { title: '单位', dataIndex: 'unitName', key: 'unitName', width: 240 },
    { title: '性别', dataIndex: 'sex', key: 'sex', width: 40 },
    { title: '出生年月', dataIndex: 'birthday', key: 'birthday', width: 120 },
    { title: '学历', dataIndex: 'educationCode', key: 'educationCode', width: 120 },
    { title: '参加工作时间', dataIndex: 'jobWorkTime', key: 'jobWorkTime', width: 120 },
    { title: '聘任时间', dataIndex: 'hireTime', key: 'hireTime', width: 120 },
    { title: '教师资格证', dataIndex: 'qualificationCode', key: 'qualificationCode', width: 80 },
    { title: '申报职称', dataIndex: 'reportRank', key: 'reportRank', width: 100 },
    {
      title: '申报专业',
      dataIndex: 'reportPro',
      key: 'reportPro',
      width: 100
    },
    { title: '履职考核等次', dataIndex: 'gradeCode', key: 'gradeCode', width: 200 },
    { title: '乡村学校或薄弱学校工作年限', dataIndex: 'years', key: 'years', width: 140 },
    {
      title: '主（辅）审意见',
      dataIndex: 'order',
      key: 'order',
      fixed: 'right',
      width: 200,
      children: [
        { title: '是否具备', dataIndex: 'isQualified', key: 'isQualified', width: 100 },
        { title: '是否同意', dataIndex: 'isAgreen', key: 'isAgreen', width: 100 }
      ]
    },
    { title: '操作', dataIndex: '', key: 'operation', fixed: 'right', width: 500 }
  ],
  HO: [
    { title: '编号', dataIndex: 'number', key: 'number', fixed: 'feft', width: 100 },
    { title: '结果', dataIndex: 'expertResult', key: 'expertResult', fixed: 'feft', width: 80 },
    { title: '姓名', dataIndex: 'userName', key: 'userName', width: 100 },
    { title: '考试成绩', dataIndex: 'examScore', key: 'examScore', width: 140 },
    { title: '单位', dataIndex: 'unitName', key: 'unitName', width: 200 },
    // { title: '单位性质', dataIndex: 'unitType', key: 'unitType', width: 40 },
    { title: '申报职称', dataIndex: 'reportRank', key: 'reportRank', width: 140 },
    {
      title: '申报专业',
      dataIndex: 'reportPro',
      key: 'reportPro',
      width: 140
    },
    {
      title: '是否新冠一线',
      dataIndex: 'reportScoreExtend',
      key: 'reportScoreExtend',
      width: 50,
      children: [
        { title: '是否一线', dataIndex: 'isCovid19Front', key: 'isCovid19Front', width: 100 },
        { title: '类型', dataIndex: 'personnelType', key: 'personnelType', width: 120 },
        { title: '起止时间', dataIndex: 'covid19Time', key: 'covid19Time', width: 200 }
      ]
    },
    {
      title: '主（辅）审意见',
      dataIndex: 'order',
      key: 'order',
      fixed: 'right',
      width: 200,
      children: [
        { title: '是否具备', dataIndex: 'isQualified', key: 'isQualified', width: 100 },
        { title: '是否同意', dataIndex: 'isAgreen', key: 'isAgreen', width: 100 }
      ]
    },
    // { title: '是否享受政策倾斜', dataIndex: 'isEnjoyPolicy', key: 'isEnjoyPolicy', width: 40 },
    { title: '操作', dataIndex: '', key: 'operation', fixed: 'right', width: 450 }
  ]
})

const columns = computed(() => {
  let _cols = TABLE_COLUMNS[reviewType]
  const type = JSON.parse(localStorage.getItem('plan')).groupInfo.type

  // 教育过滤col
  if (reviewType === 'EDU' && type) {
    _cols = _cols.filter((v) => v.key !== 'sort')
  }

  return _cols
})

const hoCovid19Format = [
  {
    type: '省内一线/援鄂',
    desc: '可提前1年申报高一级职称，符合申报条件的免于参加实践能力考试，参加疫情防控经历可视同为一年基层工作经历，视同为完成当年继续教育学分学时；参加援鄂的专业技术人员援助工作经历可视同为到上级机构进修工作经历；对于在抗疫一线工作中做出突出贡献的，受到省部级以上表彰奖励的，可以特殊人才晋升高级职称方式直接申报高一级职称评审（须完成本专业规定的工作量）'
  },
  {
    type: '参加疫情防控但未认定为一线人员',
    desc: '医务人员按照政府统一部署、卫生健康部门调派或医疗卫生机构要求，直接参与疫情防控一线工作但未被认定为一线医务人员的（须经单位核定，并提供相关证明材料），在职称评聘时其参加疫情防控经历可视同为半年基层工作经历（多次调派参加疫情防控工作但未被认定为一线的医务人员也只能视同为半年基层工作经历）'
  },
  {
    type: '过渡期一线人员',
    desc: '按照《云南省疫情防控新阶段保护关心爱护医务人员十条措施》（云应疫指发〔2023〕1号），对疫情防控救治工作中表现突出的医务人员，考核确定为优秀的，可享受1次提前1年申报（报考）上一级卫生专业技术职称（资格）。'
  }
]

export function useTable() {
  return { columns, hoCovid19Format }
}
