/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-05 11:18:35
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-10-15 09:28:28
 * @FilePath: /review-front/src/api/reviewList.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

// 评审列表请求API
import request from '@/utils/request'
import { useAppStoreHook } from '@/stores/modules/app'

/**
 * @description: 获取专家列表（公用）
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function fetchReviewList(data) {
  // console.log('APIENUM', APIENUM)
  // console.log('baseAPI', JSON.parse(localStorage.getItem('plan'))?.planInfo.reviewType)
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/expertUserReviewList',
    method: 'post',
    data
  })
}

/**
 * @description: 获取所有待评人员ID
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getReviewAllIds(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/expertUserReviewListAll',
    method: 'post',
    data
  })
}

/**
 * @description: 组长查询评审列表（调整主辅审）
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function fetchReviewListPc(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/reviewListPc',
    method: 'post',
    data
  })
}

/**
 * @description: 投票接口
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function setVote(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/expert/expertUserVoteReview',
    method: 'post',
    data
  })
}

/**
 * @description: 获取分组信息
 * @param {*} planId
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getGroupInfo(type, planId, groupId) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/group/adminGetGroup/${planId}/${groupId}`,
    method: 'get'
  })
}

/**
 * @description: 权限查看列表
 * @return {*}
 * @author: Lqi
 */
export function getFileViewPowerList(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/view/power/expertUserShowViewPowerlist',
    method: 'post',
    data
  })
}

/**
 * @description: 专家设置查看材料权限
 * @return {*}
 * @author: Lqi
 */
export function setFileViewPowerByExpert(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/view/power/setExpertUserPower',
    method: 'post',
    data
  })
}

/**
 * @description: 查询所有专家列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getExpertsAll(data) {
  return request({
    url: '/api-evaluation/' + useAppStoreHook().baseAPI + '/view/power/expertUserListAll',
    method: 'post',
    data
  })
}
