/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-05 14:38:42
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-11-04 11:32:21
 * @FilePath: /review-front/src/api/reportForm.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
/**
 * @description: 申报表API
 * @return {*}
 * @author: Lqi
 */
import request from '@/utils/request'

/**
 * @description: 获取申报年份
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function getYearByReportId(data) {
  return request({
    url: '/api-review/report/review/queryYearByReportId',
    method: 'post',
    headers: { 'content-type': 'application/x-www-form-urlencoded' },
    data: data
  })
}

/**
 * @description: 获取申报信息
 * @param {*} reportId
 * @return {*}
 * @author: Lqi
 */
export function getReportOrReview(reportId) {
  return request({
    url: '/api-review/personal/report/getReportOrReview/' + reportId,
    method: 'get'
  })
}

/**
 * @description: 获取基本信息
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getBasicInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getBasicInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取年度考核信息
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getCheckedInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getCheckedInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取学历信息
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getEduInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getEduInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取完成工作情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getFinishedInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getFinishedInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取继续教育和培训情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getLearnInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getLearnInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取专利情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getPatentInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getPatentInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取完成项目情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getProjectInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getProjectInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取职称信息
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getRankInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getRankInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取完成工作总结
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getResultInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getResultInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取表彰奖励情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getRewardInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getRewardInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取著作论文情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getThesisInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getThesisInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取学习经历信息
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getStudyInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getStudyInfo/' + id,
    method: 'get',
    params: { year }
  })
}

/**
 * @description: 获取工作情况
 * @param {*} id
 * @param {*} year
 * @return {*}
 * @author: Lqi
 */
export function getWorkInfo(id, year) {
  return request({
    url: '/api-review/personal/report/getWorkInfo/' + id,
    method: 'get',
    params: { year }
  })
}
