/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-10-31 17:28:53
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-11-23 14:15:23
 * @FilePath: /review-front/src/api/ho.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
/**
 * @description: 教育特殊表 请求接口
 * @return {*}
 * @author: Lqi
 */
import request from '@/utils/request'

/**
 * @description: 获取抗疫一线信息
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
export function getScoreExtendByUserId(id) {
  return request({
    url: '/api-review/reportScoreExtend/getInfoByUserId/' + id,
    method: 'get'
  })
}

export function getScoreExtendByReportId(id) {
  return request({
    url: '/api-review/reportScoreExtend/getInfoByReportId/' + id,
    method: 'get'
  })
}

/**
 * @description: 获取考试成绩
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
// /api-review/personal/report/getAdvancedHygieneExamScore/202373
export function getExamScoreByUserId(id) {
  return request({
    url: '/api-evaluation/personal/report/getAdvancedHygieneExamScore/' + id,
    method: 'get'
  })
}

/**
 * @description: 历史申报
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
export function getRankSituationByUserId(id) {
  return request({
    url: '/api-evaluation/personal/report/getAdvancedHygieneRankSituation/' + id,
    method: 'get'
  })
}

/**
 * @description: 历史申报
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
export function getWorkloadByUserId(id) {
  return request({
    url: '/api-evaluation/advancedHygieneWorkload/getWorkloadByReportId/' + id,
    method: 'get'
  })
}

/**
 * @description: DRG数据
 * @param {*} id
 * @return {*}
 * @author: Lqi
 */
export function getDRGInfo(id) {
  return request({
    url: '/api-evaluation/evaluation-ho/personnel/drg/' + id,
    method: 'get'
  })
}
