/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-03-06 15:18:05
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-03-06 15:19:19
 * @FilePath: /review-front/src/api/observer.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 观察员
import request from '@/utils/request'

/**
 * @description: 观察员获取审核列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function fetchReviewList(data) {
  return request({
    url: '/api-evaluation/api/observer/reviewList',
    method: 'get',
    data
  })
}

/**
 * @description: 获取观察员所在计划和组的专家列表
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function fetchExpertList(data) {
  return request({
    url: '/api-evaluation/api/observer/getExpertList',
    method: 'post',
    data
  })
}

/**
 * @description: 设置主审
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function setMainReview(data) {
  return request({
    url: '/api-evaluation/api/observer/setMainReview',
    method: 'post',
    data
  })
}
