/*
 * @Author: lqi 575920678@qq.com
 * @Date: 2024-02-23 14:24:08
 * @LastEditors: lqi 575920678@qq.com
 * @LastEditTime: 2024-12-11 14:50:56
 * @FilePath: /review-front/src/api/login.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'

/**
 * @description:
 * @param {*} data
 * @param {*} type 类型（专家/观察员）
 * @return {*}
 * @author: Lqi
 */
export function loginByUsername(data, type) {
  return request({
    url: `/api-evaluation/api/auth/${type}Login`,
    method: 'post',
    data
  })
}

/**
 * @description: 退出登录
 * @param {*} type类型（专家/观察员）
 * @return {*}
 * @author: Lqi
 */
export function logout(type) {
  return request({
    url: '/api-evaluation/api/auth/' + type + 'Logout',
    method: 'get'
  })
}

/**
 * @description: 管理员登录
 * @param {*} data
 * @return {*}
 * @author: Lqi
 */
export function adminLogin(data) {
  return request({
    url: `/api-evaluation/auth/login`,
    method: 'post',
    data
  })
}

/**
 * @description: 管理员退出登录
 * @return {*}
 * @author: Lqi
 */
export function adminLogout() {
  return request({
    url: '/api-evaluation/api/auth/logout',
    method: 'get'
  })
}
