import request from '@/utils/request'

/**
 * @description:评审展示图形显示-通过personelId查询参评
 * @param {*} personelId
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getPersonelReviewDetail(personelId, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/personnel/getReviewResultRedis/${personelId}`,
    method: 'get'
  })
}

/**
 * @description: 评审展示图形显示-获取会场情况数据专家实到人数-评审专家法定票数-参评总人数-参评未评人数-参评已评人数
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getReviewDetail(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/personnel/getReviewShowFromRedis`,
    method: 'post',
    data
  })
}

/**
 * @description: 评审展示图形显示-参评人员评审情况查询
 * @param {*} data
 * @param {*} type
 * @return {*}
 * @author: Lqi
 */
export function getResultList(data, type) {
  return request({
    url: `/api-evaluation/evaluation${
      type && type !== 'COMMON' ? '-' + type.toLowerCase() : ''
    }/personnel/resultListFromRedis`,
    method: 'post',
    data
  })
}
